return function(Color, Instance)

Color.invisible = Color.rgba(0.0, 0.0, 0.0, 0)

Color.gray = function(gray, alpha)
    return Color.rgba(gray, gray, gray, alpha or 1)
end

Color.white     = Color.gray(1.0)
Color.black     = Color.gray(0.0)

function Instance:archive()
    return 'RGBA', self:getComponents()
end

local function round(x) return math.floor(x + 0.5) end

function Instance:toSVG()
    local components = self:getComponents()
    if components.alpha == 0 then
        return 'none'
    elseif components.alpha == 1 then
        return string.format('#%02x%02x%02x', round(255 * components.red), round(255 * components.green), round(255 * components.blue))
    else
        return string.format('rgba(%d, %d, %d, %g)', round(255 * components.red), round(255 * components.green), round(255 * components.blue), components.alpha)
    end
end

end
